<?php
require_once __DIR__ . "/../includes/config.php";
require_once __DIR__ . "/../includes/db.php";

$next = $_GET["next"] ?? (BASE_URL . "/start.php");
$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $email = trim($_POST["email"] ?? "");
  $password = $_POST["password"] ?? "";

  $stmt = $conn->prepare("SELECT id, email, password_hash FROM users WHERE email = ?");
  $stmt->bind_param("s", $email);
  $stmt->execute();

  $result = $stmt->get_result();
  $u = $result->fetch_assoc();

  if ($u && password_verify($password, $u["password_hash"])) {
    $_SESSION["user_id"] = $u["id"];
    $_SESSION["user_email"] = $u["email"];
    header("Location: " . $next);
    exit();
  } else {
    $error = "Invalid email or password.";
  }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Login</title></head>
<body>

  <h2>Login</h2>

  <?php if(isset($_GET["registered"])): ?>
    <p style="color:green;">Account created. Please login.</p>
  <?php endif; ?>

  <?php if($error): ?><p style="color:red;"><?php echo $error; ?></p><?php endif; ?>

  <form method="POST">
    <input name="email" type="email" placeholder="Email" required><br><br>
    <input name="password" type="password" placeholder="Password" required><br><br>
    <button type="submit">Login</button>
  </form>

  <p>No account? <a href="<?php echo BASE_URL; ?>/auth/register.php">Sign up</a></p>

</body>
</html>
