<?php
require_once __DIR__ . "/includes/config.php";
require_once __DIR__ . "/includes/db.php";

// 🔒 Require login
if (!isset($_SESSION["user_id"])) {
  header("Location: /checkmate/auth/login.php?next=/checkmate/dashboard.php");
  exit();
}

$user_id = $_SESSION["user_id"];

// Fetch requests
$stmt = $conn->prepare("SELECT * FROM verification_requests WHERE user_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Dashboard - Checkmate</title>
  <link rel="stylesheet" href="style.css">
  <style>
    .dashboard {
      padding: 60px 20px;
      max-width: 1100px;
      margin: auto;
    }

    .dashboard h1 {
      margin-bottom: 30px;
    }

    .request-card {
      background: #fff;
      padding: 20px;
      border-radius: 14px;
      margin-bottom: 20px;
      box-shadow: 0 10px 30px rgba(0,0,0,0.05);
    }

    .request-card h3 {
      margin-bottom: 10px;
      color: #142C56;
    }

    .request-card p {
      margin: 4px 0;
      font-size: 14px;
      color: #444;
    }

    .file-link {
      display: inline-block;
      margin-top: 10px;
      padding: 6px 14px;
      background: #F5B400;
      border-radius: 999px;
      text-decoration: none;
      font-weight: 600;
      color: #000;
    }

    .empty-state {
      padding: 40px;
      background: #fff;
      border-radius: 14px;
      text-align: center;
    }
  </style>
</head>
<body>

<div class="dashboard">
  <h1>Your Verification Requests</h1>

  <?php if ($result->num_rows > 0): ?>
    <?php while ($row = $result->fetch_assoc()): ?>
      <div class="request-card">
        <h3>Tenant: <?= htmlspecialchars($row["tenant_name"]) ?></h3>
        <p><strong>Company:</strong> <?= htmlspecialchars($row["company_name"]) ?></p>
        <p><strong>Rental Address:</strong>
          <?= htmlspecialchars($row["street"]) ?>,
          <?= htmlspecialchars($row["city"]) ?>,
          <?= htmlspecialchars($row["state"]) ?>
        </p>
        <p><strong>Move In:</strong> <?= htmlspecialchars($row["move_in"]) ?></p>
        <p><strong>Move Out:</strong> <?= htmlspecialchars($row["move_out"]) ?></p>
        <p><strong>Submitted:</strong> <?= htmlspecialchars($row["created_at"]) ?></p>

        <a class="file-link"
           href="/checkmate/<?= htmlspecialchars($row["application_file_path"]) ?>"
           target="_blank">
           View Uploaded Application
        </a>
      </div>
    <?php endwhile; ?>
  <?php else: ?>
    <div class="empty-state">
      <p>No verification requests yet.</p>
      <a href="/checkmate/index.php" class="file-link">Create New Request</a>
    </div>
  <?php endif; ?>

</div>

</body>
</html>
