<?php

// =====================
// PHPMailer (must be at top-level before other code)
// =====================
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . "/../includes/config.php";
require_once __DIR__ . "/../includes/db.php";

// PHPMailer files (your folder matches this)
require_once __DIR__ . "/../includes/PHPMailer/Exception.php";
require_once __DIR__ . "/../includes/PHPMailer/PHPMailer.php";
require_once __DIR__ . "/../includes/PHPMailer/SMTP.php";

// =====================
// CONFIG (EDIT THESE)
// =====================
define("ADMIN_EMAIL", "info@checkmeneverify.com"); // <-- admin email you gave

// Namecheap email SMTP (choose the right one for your setup)
// If you use Namecheap Private Email, use smtp.privateemail.com
// If you use cPanel email, mail.yourdomain.com often works

define("SMTP_HOST", "smtp.privateemail.com"); // try: smtp.privateemail.com (Private Email)
define("SMTP_USER", "info@checkmeneverify.com"); // mailbox username
define("SMTP_PASS", "YOUR_MAILBOX_PASSWORD");    // mailbox password (NOT gmail app password)
define("SMTP_PORT", 465);                        // 465 (SSL) or 587 (TLS)
define("SMTP_SECURE", "ssl");                    // "ssl" for 465, "tls" for 587

// =====================
// BLOCK NON-POST
// =====================
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
  header("Location: " . BASE_URL . "/index.php");
  exit();
}

// ---------- Helper ----------
function clean($v) {
  return trim($v ?? "");
}

// ---------- Collect fields ----------
$company_name     = clean($_POST["company_name"] ?? "");
$owner_name       = clean($_POST["owner_name"] ?? "");
$requester_email  = clean($_POST["email"] ?? "");
$requester_phone  = clean($_POST["phone"] ?? "");

$tenant_name      = clean($_POST["tenant_name"] ?? "");
$tenant_email     = clean($_POST["tenant_email"] ?? "");
$tenant_phone     = clean($_POST["tenant_phone"] ?? "");

$street           = clean($_POST["street"] ?? "");
$city             = clean($_POST["city"] ?? "");
$state            = clean($_POST["state"] ?? "");
$zip              = clean($_POST["zip"] ?? "");
$move_in          = clean($_POST["move_in"] ?? "");
$move_out         = clean($_POST["move_out"] ?? "");

$agree            = isset($_POST["agree"]) ? 1 : 0;

$user_id = $_SESSION["user_id"] ?? null;

// ---------- Basic validation ----------
$required = [
  $company_name, $owner_name, $requester_email, $requester_phone,
  $tenant_name, $tenant_email, $tenant_phone,
  $street, $city, $state, $zip, $move_in, $move_out
];

foreach ($required as $val) {
  if ($val === "") {
    header("Location: " . BASE_URL . "/index.php?error=missing_fields");
    exit();
  }
}

if (!$agree) {
  header("Location: " . BASE_URL . "/index.php?error=agree_required");
  exit();
}

// Validate dates (basic)
if (strtotime($move_in) === false || strtotime($move_out) === false) {
  header("Location: " . BASE_URL . "/index.php?error=bad_dates");
  exit();
}

// ---------- File upload ----------
if (!isset($_FILES["application_file"]) || $_FILES["application_file"]["error"] !== UPLOAD_ERR_OK) {
  header("Location: " . BASE_URL . "/index.php?error=file_required");
  exit();
}

$fileTmp  = $_FILES["application_file"]["tmp_name"];
$fileName = $_FILES["application_file"]["name"];
$fileSize = $_FILES["application_file"]["size"];

// 10MB max
$maxSize = 10 * 1024 * 1024;
if ($fileSize > $maxSize) {
  header("Location: " . BASE_URL . "/index.php?error=file_too_large");
  exit();
}

// Allowed extensions
$allowedExt = ["pdf", "doc", "docx", "jpg", "jpeg", "png"];
$ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
if (!in_array($ext, $allowedExt, true)) {
  header("Location: " . BASE_URL . "/index.php?error=file_type");
  exit();
}

// Safer new file name
$uploadsDir = __DIR__ . "/../uploads";
if (!is_dir($uploadsDir)) {
  mkdir($uploadsDir, 0755, true);
}

$newName = "app_" . date("Ymd_His") . "_" . bin2hex(random_bytes(6)) . "." . $ext;
$destPath = $uploadsDir . "/" . $newName;

// Move file
if (!move_uploaded_file($fileTmp, $destPath)) {
  header("Location: " . BASE_URL . "/index.php?error=file_upload_failed");
  exit();
}

// Path to store in DB (relative)
$dbFilePath = "uploads/" . $newName;

// ---------- Insert into DB ----------
$stmt = $conn->prepare("
  INSERT INTO verification_requests
  (user_id, company_name, owner_name, requester_email, requester_phone,
   tenant_name, tenant_email, tenant_phone,
   street, city, state, zip, move_in, move_out,
   application_file_path, application_file_original, agreed)
  VALUES
  (?, ?, ?, ?, ?,
   ?, ?, ?,
   ?, ?, ?, ?, ?, ?,
   ?, ?, ?)
");

$stmt->bind_param(
  "isssssssssssssssi",
  $user_id,
  $company_name, $owner_name, $requester_email, $requester_phone,
  $tenant_name, $tenant_email, $tenant_phone,
  $street, $city, $state, $zip, $move_in, $move_out,
  $dbFilePath, $fileName, $agree
);

if (!$stmt->execute()) {
  // If DB insert fails, delete uploaded file to avoid orphan files
  @unlink($destPath);
  header("Location: " . BASE_URL . "/index.php?error=db_insert_failed");
  exit();
}

$requestId = $stmt->insert_id;

// =====================
// SEND EMAIL NOTIFICATION (ADMIN + USER)
// =====================
try {
  $mail = new PHPMailer(true);

  // SMTP Settings
  $mail->isSMTP();
  $mail->Host       = SMTP_HOST;
  $mail->SMTPAuth   = true;
  $mail->Username   = SMTP_USER;
  $mail->Password   = SMTP_PASS;

  if (SMTP_SECURE === "ssl") {
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
  } else {
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
  }

  $mail->Port = SMTP_PORT;

  $mail->setFrom(SMTP_USER, "Checkmate");
  $mail->isHTML(true);

  // Escape for HTML email safety
  $esc = fn($s) => htmlspecialchars((string)$s, ENT_QUOTES, "UTF-8");

  // ------------------------------
  // 1) Admin email (detailed)
  // ------------------------------
  $mail->addAddress(ADMIN_EMAIL, "Checkmate Admin");
  $mail->addReplyTo($requester_email, $owner_name);

  $mail->Subject = "New Verification Request Submitted ✅";

  $mail->Body = "
    <h2>New Verification Request Submitted ✅</h2>
    <p><b>Request ID:</b> {$esc($requestId)}</p>
    <p><b>Company:</b> {$esc($company_name)}</p>
    <p><b>Owner:</b> {$esc($owner_name)}</p>
    <p><b>Requester Email:</b> {$esc($requester_email)}</p>
    <p><b>Requester Phone:</b> {$esc($requester_phone)}</p>
    <hr>
    <p><b>Tenant:</b> {$esc($tenant_name)}</p>
    <p><b>Tenant Email:</b> {$esc($tenant_email)}</p>
    <p><b>Tenant Phone:</b> {$esc($tenant_phone)}</p>
    <hr>
    <p><b>Address:</b> {$esc($street)}, {$esc($city)}, {$esc($state)} {$esc($zip)}</p>
    <p><b>Move In:</b> {$esc($move_in)}</p>
    <p><b>Move Out:</b> {$esc($move_out)}</p>
    <hr>
    <p><b>Uploaded File Name:</b> {$esc($fileName)}</p>
    <p><b>Stored Path:</b> {$esc($dbFilePath)}</p>
  ";

  $mail->send();

  // ------------------------------
  // 2) User email (confirmation)
  // ------------------------------
  $mail->clearAddresses();
  $mail->clearReplyTos();

  $mail->addAddress($requester_email, $owner_name);

  $mail->Subject = "Verification Request Received ✅";

  $mail->Body = "
    <h3>Request received ✅</h3>
    <p>Hello {$esc($owner_name)},</p>
    <p>Your verification request has been submitted successfully.</p>
    <p><b>Request ID:</b> {$esc($requestId)}</p>
    <p>We will review and contact you shortly.</p>
    <br>
    <p>— Checkmate Team</p>
  ";

  $mail->send();

} catch (Exception $e) {
  // Don't break the app if email fails
  error_log("Mailer Error (verification.php): " . ($mail->ErrorInfo ?? $e->getMessage()));
}

// Redirect (works locally + on hosting)
header("Location: " . BASE_URL . "/dashboard.php");
exit();
