document.addEventListener("DOMContentLoaded", function () {

  const modal = document.getElementById("getStartedModal");
  const closeBtn = document.getElementById("closeGetStarted");

  function openModal() {
    if (!modal) return;
    modal.classList.add("is-open");
    modal.setAttribute("aria-hidden", "false");
    document.body.style.overflow = "hidden";
  }

  function closeModal() {
    if (!modal) return;
    modal.classList.remove("is-open");
    modal.setAttribute("aria-hidden", "true");
    document.body.style.overflow = "";
  }

  // Close button
  if (closeBtn) {
    closeBtn.addEventListener("click", closeModal);
  }

  // Close when clicking outside
  if (modal) {
    modal.addEventListener("click", function (e) {
      if (e.target === modal) closeModal();
    });
  }

  // ESC key closes
  document.addEventListener("keydown", function (e) {
    if (e.key === "Escape" && modal?.classList.contains("is-open")) {
      closeModal();
    }
  });

  // 🔥 AUTO
const params = new URLSearchParams(window.location.search);

  if (params.get("open") === "get-started") {
    console.log("Opening modal...");
    openModal();
  }

});
// MULTI STEP FORM
const form = document.getElementById("verificationForm");
const steps = form ? form.querySelectorAll(".form-step") : [];
let currentStep = 0;

function showStep(index) {
  steps.forEach((step, i) => {
    step.classList.toggle("active", i === index);
  });
}

form?.querySelectorAll(".next-step").forEach((btn) => {
  btn.addEventListener("click", () => {
    if (currentStep < steps.length - 1) {
      currentStep++;
      showStep(currentStep);
    }
  });
});

form?.querySelectorAll(".prev-step").forEach((btn) => {
  btn.addEventListener("click", () => {
    if (currentStep > 0) {
      currentStep--;
      showStep(currentStep);
    }
  });
});
